// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     third_party/mojo/src/mojo/public/interfaces/bindings/interface_control_messages.mojom
//

package org.chromium.mojo.bindings;

public final class RunMessageParams extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 24;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public int reserved0;
    public int reserved1;
    public QueryVersion queryVersion;

    private RunMessageParams(int version) {
        super(STRUCT_SIZE, version);
    }

    public RunMessageParams() {
        this(0);
    }

    public static RunMessageParams deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static RunMessageParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        RunMessageParams result = new RunMessageParams(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.reserved0 = decoder0.readInt(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.reserved1 = decoder0.readInt(12);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
            result.queryVersion = QueryVersion.decode(decoder1);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(reserved0, 8);
        encoder0.encode(reserved1, 12);
        encoder0.encode(queryVersion, 16, false);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        RunMessageParams other = (RunMessageParams) object;
        if (this.reserved0 != other.reserved0)
            return false;
        if (this.reserved1 != other.reserved1)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.queryVersion, other.queryVersion))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(reserved0);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(reserved1);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(queryVersion);
        return result;
    }
}

